We provide the data splits we used in our experiments on TruthfulQA in the file `ids_splits.json`. This file contains the exact sample indices we used for training, validation and testing. The data itself can be downloaded from Hugging Face Hub. To download and split the dataset, you can use the following code snipet:

```python
from datasets import load_dataset, DatasetDict
import json


dataset = load_dataset('truthful_qa', 'multiple_choice')['validation']
with open('ids_splits.json', 'r') as f:
    ids_splits = json.load(f)
dataset = DatasetDict({s: dataset.select(ids_splits[s]) for s in ids_splits.keys()})

print(dataset)
```

Expected output:

```
DatasetDict({
    train: Dataset({
        features: ['question', 'mc1_targets', 'mc2_targets'],
        num_rows: 367
    })
    eval: Dataset({
        features: ['question', 'mc1_targets', 'mc2_targets'],
        num_rows: 41
    })
    test: Dataset({
        features: ['question', 'mc1_targets', 'mc2_targets'],
        num_rows: 409
    })
})
```

This code requires Hugging Face's datasets library, which can be installed using pip:

```
pip install datasets
```