import os
import re

from .openai_utils import (chatgpt_chatbot_editing,
                           chatgpt_zero_shot_classification, join_hist)


def is_strategic_closing(message):

    prompt = f""" We are in the context of a negotiation.
    Definition of a good closing strategy:  
    A good closing strategy can be to incorporate one of these in the last turns:
                                - an acknowledgment of the opponent’s negotiation skill
                                - A recognition of the buyer’s loss in the negotiation game.
                            Also the last turns should not contain one of those:
                                - A celebratory statement of the outcome of the negotiation.
                                - Statements that imply that the buyer got a better deal
    Does this message :{message} match the definition of a good closing strategy ?
    Answer only with True or False."""
    edit = chatgpt_zero_shot_classification(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )
    return edit
    # return re.sub(r'\b(?!True|False)\w+\b',"",edit)


def edit_strategic_closing(passage):

    prompt = f""" You are an assistant aimed to reedit text to help a buyer in a negotiation.
                You are adressing directly to the buyer, use the second person (You).
                The buyer did not adapt a good closing strategy in this passage: {passage}
                Give the buyer an explanation.
                
                EXAMPLE:
                "As you draw close to agreement, this is another moment to manage your counterpart’s impression. You want the counterpart to feel that they have succeeded. Express pain at your extensive concessions. Tell them that they drive a hard bargain. Don’t gloat if you think you have done well. All this helps them feel commitment to the deal and willingness to negotiate with you again."
                """
    edit = chatgpt_chatbot_editing(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )
    return re.sub(r"Buyer:|Seller:", "", edit)
