# AMR-Evol: Adaptive Modular Response Evolution Elicits Better Knowledge Distillation for Large Language Models in Code Generation

## Install
```bash
pip install -r requirements.txt
```

## Direct Response Distillation
```bash
cd src
python direct.response.py --input_path="data/instruction.json" \
    --output_path="data/instruction.direct.json" \
    --sys_path="prompts/direct.txt" \
    --api_key="Your OpenAI Key"
```

## AMR-Evol

### Modularized Decomposition
```bash
cd src
python modularized.py --input_path="data/instruction.direct.json" \
    --output_path="data/instruction.direct.modularized.json" \
    --sys_path="prompts/modularized.txt" \
    --api_key="Your OpenAI Key"
```

### Adaptive Response Evolution
```bash
cd src
python function.embeddings.py --database_path="data/function.database.json" \
    --output_path="data/function.embeds.pkl"

python function.retrieval.py --fun_path="data/function.database.json" \
    --embed_path="data/function.embeds.pkl" \
    --query_path="data/instruction.direct.modularized.[xx:xx].json" \
    --output_path="data/instruction.direct.modularized.retrieved[xx:xx].json"

python evol.response.py --input_path="data/instruction.direct.modularized.retrieved[xx:xx].json" \
    --output_path="data/instruction.direct.modularized.retrieved.amr[xx:xx].json",
    --sys_path="prompts/evol.response.txt" \
    --api_key="Your OpenAI Key"
```