/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;

public class SequenceSampler
implements BestSequenceFinder {
    @Override
    public int[] bestSequence(SequenceModel ts) {
        int[] sample = new int[ts.length() + ts.leftWindow() + ts.rightWindow()];
        for (int pos = ts.leftWindow(); pos < sample.length - ts.rightWindow(); ++pos) {
            double[] scores = ts.scoresOf(sample, pos);
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = Math.exp(scores[i]);
            }
            ArrayMath.normalize(scores);
            int l = ArrayMath.sampleFromDistribution(scores);
            sample[pos] = ts.getPossibleValues(pos)[l];
        }
        return sample;
    }
}

