/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.surface.PatternToken;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SurfacePattern
implements Serializable,
Comparable<SurfacePattern> {
    private static final long serialVersionUID = 1L;
    protected String[] prevContext;
    protected String[] nextContext;
    protected PatternToken token;
    protected int hashcode;
    protected Genre genre;
    public static boolean insertModifierWildcard = false;
    static Pattern p1 = Pattern.compile(Pattern.quote("[") + "\\s*" + Pattern.quote("{") + "\\s*(lemma|word)\\s*:\\s*/" + Pattern.quote("\\Q") + "(.*)" + Pattern.quote("\\E") + "/\\s*" + Pattern.quote("}") + "\\s*" + Pattern.quote("]"));
    static Pattern p2 = Pattern.compile(Pattern.quote("[") + "\\s*" + Pattern.quote("{") + "\\s*(.*)\\s*:\\s*(.*)\\s*" + Pattern.quote("}") + "\\s*" + Pattern.quote("]"));

    public Genre getGenre() {
        return this.genre;
    }

    public void setGenre(Genre genre) {
        this.genre = genre;
    }

    public SurfacePattern(String[] prevContext, PatternToken token, String[] nextContext, Genre genre) {
        prevContext = this.trim(prevContext);
        nextContext = this.trim(nextContext);
        this.setPrevContext(prevContext);
        this.setNextContext(nextContext);
        this.setToken(token);
        this.genre = genre;
        this.hashcode = this.toString().hashCode();
    }

    String[] trim(String[] p) {
        if (p == null) {
            return null;
        }
        for (int i = 0; i < p.length; ++i) {
            p[i] = p[i].trim();
        }
        return p;
    }

    public static String getContextStr(CoreLabel tokenj, boolean useLemmaContextTokens, boolean lowerCaseContext) {
        String str = "";
        if (useLemmaContextTokens) {
            String tok = tokenj.lemma();
            if (lowerCaseContext) {
                tok = tok.toLowerCase();
            }
            str = "[{lemma:/" + Pattern.quote(tok) + "/}] ";
        } else {
            String tok = tokenj.word();
            if (lowerCaseContext) {
                tok = tok.toLowerCase();
            }
            str = "[{word:/" + Pattern.quote(tok) + "/}] ";
        }
        return str;
    }

    public static String getContextStr(String w) {
        String str = "[/" + Pattern.quote(w) + "/] ";
        return str;
    }

    public String toString(List<String> notAllowedClasses) {
        String prevContextStr = "";
        String nextContextStr = "";
        if (this.prevContext != null) {
            prevContextStr = StringUtils.join(this.prevContext, " ");
        }
        if (this.nextContext != null) {
            nextContextStr = StringUtils.join(this.nextContext, " ");
        }
        return (prevContextStr + " " + this.getToken().getTokenStr(notAllowedClasses) + " " + nextContextStr).trim();
    }

    public String toString(String morePreviousPattern, String moreNextPattern, List<String> notAllowedClasses) {
        String prevContextStr = "";
        String nextContextStr = "";
        if (this.prevContext != null) {
            prevContextStr = StringUtils.join(this.prevContext, " ");
        }
        if (this.nextContext != null) {
            nextContextStr = StringUtils.join(this.nextContext, " ");
        }
        return (prevContextStr + " " + morePreviousPattern + " " + this.getToken().getTokenStr(notAllowedClasses) + " " + moreNextPattern + " " + nextContextStr).trim();
    }

    public String getPrevContextStr() {
        String prevContextStr = "";
        if (this.prevContext != null) {
            prevContextStr = StringUtils.join(this.prevContext, " ");
        }
        return prevContextStr;
    }

    public String getNextContextStr() {
        String nextContextStr = "";
        if (this.nextContext != null) {
            nextContextStr = StringUtils.join(this.nextContext, " ");
        }
        return nextContextStr;
    }

    public int equalContext(SurfacePattern p) {
        if (p.equals(this)) {
            return 0;
        }
        if (Arrays.equals(this.prevContext, p.getPrevContext()) && Arrays.equals(this.nextContext, p.getNextContext())) {
            int this_restriction = 0;
            int p_restriction = 0;
            if (this.getToken().useTag) {
                ++this_restriction;
            }
            if (p.getToken().useTag) {
                ++p_restriction;
            }
            if (this.getToken().useNER) {
                ++this_restriction;
            }
            if (p.getToken().useNER) {
                ++p_restriction;
            }
            if (this.getToken().useTargetParserParentRestriction) {
                ++this_restriction;
            }
            if (p.getToken().useTargetParserParentRestriction) {
                ++p_restriction;
            }
            return (this_restriction -= this.getToken().numWordsCompound) - (p_restriction -= this.getToken().numWordsCompound);
        }
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object b) {
        if (!(b instanceof SurfacePattern)) {
            return false;
        }
        SurfacePattern p = (SurfacePattern)b;
        if (!this.token.equals(p.token)) {
            return false;
        }
        if (this.prevContext == null && p.prevContext != null || this.prevContext != null && p.prevContext == null) {
            return false;
        }
        if (this.nextContext == null && p.nextContext != null || this.nextContext != null && p.nextContext == null) {
            return false;
        }
        if (this.prevContext != null && !Arrays.equals(this.prevContext, p.prevContext)) {
            return false;
        }
        return this.nextContext == null || Arrays.equals(this.nextContext, p.nextContext);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toStringToWrite() {
        return this.getPrevContextStr() + "##" + this.getToken().toStringToWrite() + "##" + this.getNextContextStr();
    }

    public String[] getSimplerTokensPrev() {
        return this.getSimplerTokens(this.prevContext);
    }

    public String[] getSimplerTokensNext() {
        return this.getSimplerTokens(this.nextContext);
    }

    public String[] getSimplerTokens(String[] p) {
        if (p == null) {
            return null;
        }
        String[] sim = new String[p.length];
        for (int i = 0; i < p.length; ++i) {
            assert (p[i] != null) : "How is the any one " + Arrays.toString(p) + " null!";
            if (p1 == null) {
                throw new RuntimeException("how is p1 null");
            }
            Matcher m = p1.matcher(p[i]);
            if (m.matches()) {
                sim[i] = m.group(2);
                continue;
            }
            Matcher m2 = p2.matcher(p[i]);
            if (m2.matches()) {
                sim[i] = m2.group(2);
                continue;
            }
            if (p[i].startsWith("$FILLER")) {
                sim[i] = "FW";
                continue;
            }
            if (p[i].startsWith("$STOP")) {
                sim[i] = "SW";
                continue;
            }
            throw new RuntimeException("Cannot understand " + p[i]);
        }
        return sim;
    }

    public String toStringSimple() {
        Object[] simprev = this.getSimplerTokensPrev();
        Object[] simnext = this.getSimplerTokensNext();
        String prevstr = simprev == null ? "" : StringUtils.join(simprev, " ");
        String nextstr = simnext == null ? "" : StringUtils.join(simnext, " ");
        String sim = prevstr.trim() + " <b>" + this.getToken().toStringToWrite() + "</b> " + nextstr.trim();
        return sim;
    }

    public String[] getPrevContext() {
        return this.prevContext;
    }

    public void setPrevContext(String[] prevContext) {
        this.prevContext = prevContext;
    }

    public String[] getNextContext() {
        return this.nextContext;
    }

    public void setNextContext(String[] nextContext) {
        this.nextContext = nextContext;
    }

    public PatternToken getToken() {
        return this.token;
    }

    public void setToken(PatternToken token) {
        this.token = token;
    }

    public static boolean sameGenre(SurfacePattern p1, SurfacePattern p2) {
        return p1.getGenre().equals((Object)p2.getGenre());
    }

    public static boolean subsumesArray(String[] array1, String[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array2.length > array1.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (!array1[i].equals(array2[0])) continue;
            boolean found = true;
            for (int j = 0; j < array2.length; ++j) {
                if (array1.length > i + j && array2[j].equals(array1[i + j])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static boolean subsumes(SurfacePattern p1, SurfacePattern p2) {
        return SurfacePattern.subsumesArray(p1.getNextContext(), p2.getNextContext()) && SurfacePattern.subsumesArray(p1.getPrevContext(), p2.getPrevContext());
    }

    public static boolean subsumesEitherWay(SurfacePattern p1, SurfacePattern p2) {
        return SurfacePattern.subsumes(p1, p2) || SurfacePattern.subsumes(p2, p1);
    }

    public static boolean sameRestrictions(SurfacePattern p1, SurfacePattern p2) {
        PatternToken token1 = p1.token;
        PatternToken token2 = p2.token;
        return token1.equals(token2);
    }

    @Override
    public int compareTo(SurfacePattern o) {
        int numthat;
        int numthis = this.getPreviousContextLen() + this.getNextContextLen();
        if (numthis > (numthat = o.getPreviousContextLen() + o.getNextContextLen())) {
            return -1;
        }
        if (numthis < numthat) {
            return 1;
        }
        return this.toString().compareTo(o.toString());
    }

    public int getPreviousContextLen() {
        if (this.prevContext == null) {
            return 0;
        }
        return this.prevContext.length;
    }

    public int getNextContextLen() {
        if (this.nextContext == null) {
            return 0;
        }
        return this.nextContext.length;
    }

    public static boolean sameLength(SurfacePattern p1, SurfacePattern p2) {
        return p1.getPreviousContextLen() == p2.getPreviousContextLen() && p1.getNextContextLen() == p2.getNextContextLen();
    }

    public static enum Genre {
        PREV,
        NEXT,
        PREVNEXT;

    }
}

