class config_class:
    def __init__(self, **kwargs):
        for x in kwargs:
            setattr(self, x, kwargs.get(x))

TRANSFORMERS_HIDDEN_SIZE_TO_CLS_TENSOR_SHAPE = {
    768: [8, 8, 12, 12, 8, 8],
    1024: [4, 8, 8, 16, 8, 8, 4],
    1280: [4, 4, 8, 8, 8, 8, 5, 5],
    1536: [4, 4, 8, 8, 8, 8, 6, 6],
    1600: [5, 5, 8, 8, 8, 8, 5, 5],
    2304: [4, 4, 8, 8, 8, 8, 9, 9],
    4096: [4, 4, 16, 16, 16, 16, 4, 4],
    5120: [8, 8, 8, 10, 10, 8, 8],
    8192: [4, 4, 16, 16, 16, 16, 8, 8],
}

TRANSFORMERS_HIDDEN_SIZE_TO_TENSOR_SHAPE = {
    5: {
        768: [5, 8, 12, 8],
        1024: [4, 8, 5, 8, 4],
        1280: [4, 8, 5, 8, 5],
        1536: [4, 8, 5, 8, 6],
        1600: [5, 8, 5, 8, 5],
        2304: [5, 8, 8, 4, 9],
        4096: [16, 16, 5, 4, 4],
        5120: [5, 8, 10, 8, 8],
        8192: [4, 16, 16, 10, 4],
    },
    8: {
        768: [8, 8, 12, 8],
        1024: [4, 8, 8, 8, 4],
        1280: [4, 8, 8, 8, 5],
        1536: [4, 8, 8, 8, 6],
        1600: [5, 8, 8, 8, 5],
        2304: [8, 8, 8, 4, 9],
        4096: [16, 16, 8, 4, 4],
        5120: [8, 8, 10, 8, 8],
        8192: [4, 16, 16, 16, 4],
    },
    16: {
        768: [8, 16, 12, 8],
        1024: [4, 8, 16, 8, 4],
        1280: [4, 8, 16, 8, 5],
        1536: [4, 8, 16, 8, 6],
        1600: [5, 8, 16, 8, 5],
        2048: [8, 8, 8, 8, 8],#
        2304: [8, 8, 8, 8, 9],
        2560: [10, 8, 8, 8, 8],#
        3072: [12, 8, 8, 8, 8],#
        4096: [16, 16, 16, 16],
        5120: [8, 16, 10, 8, 8],
        8192: [4, 16, 16, 16, 8],
    },
    32: {
        768: [4, 8, 12, 8, 8],
        1024: [4, 8, 16, 8, 4],
        1280: [4, 8, 16, 8, 5],
        1536: [4, 8, 16, 8, 6],
        1600: [5, 8, 16, 8, 5],
        2304: [8, 8, 16, 8, 9],
        3072: [6, 8, 8, 8, 8, 4],
        4096: [16, 16, 16, 4, 4],
        5120: [8, 16, 10, 8, 8],
        8192: [4, 16, 16, 16, 8],
    },
    64: {
        768: [8, 8, 12, 8, 8],
        1024: [4, 8, 8, 8, 8, 4],
        1280: [4, 8, 8, 8, 8, 5],
        1536: [4, 8, 8, 8, 8, 6],
        1600: [5, 8, 8, 8, 8, 5],
        2048: [4, 8, 8, 8, 8, 8],
        2304: [8, 8, 8, 8, 8, 9],
        2560: [5, 8, 8, 8, 8, 8],
        3072: [6, 8, 8, 8, 8, 8],
        # 4096: [8, 8, 8, 8, 8, 8],
        4096: [8, 8, 8, 8, 8, 8],
        # 4096: [64, 64, 64],
        # 4096: [512, 512],
        5120: [5, 8, 8, 16, 8, 8],
        8192: [4, 16, 16, 16, 8, 4],
    },
    128: {
        768: [8, 16, 12, 8, 8],
        1024: [4, 8, 16, 8, 8, 4],
        1280: [4, 8, 16, 8, 8, 5],
        1536: [4, 8, 16, 8, 8, 6],
        1600: [5, 8, 16, 8, 8, 5],
        4096: [16, 16, 16, 8, 4, 4],
        5120: [5, 8, 16, 16, 8, 8],
        8192: [4, 16, 16, 16, 16, 4],
    },
}
