from compute_logme import compute_logme_from_list
from dataset_processing_info import dataset_info_dict

target_dataset_names = [
    'imdb_plain_text',
    'tweet_eval_emotion',
    'tweet_eval_sentiment',
    'llm-book__JGLUE_JSTS',
    'google_wellformed_query_default',
    'paws-x_en',
    'md_gender_bias_convai2_inferred',
    'google__civil_comments_default'
]
source_dataset_names = dataset_info_dict.keys()
num_source_samples = 10000
num_target_samples = 1000
num_val_samples = 1000
transfer_exceptions = {}
for target_dataset_name in target_dataset_names:
    compute_logme_from_list(target_dataset_name=target_dataset_name,
                            source_dataset_names=source_dataset_names,
                            num_target_samples=num_target_samples,
                            num_source_samples=num_source_samples)
