#!/bin/bash

partition=your_partition
base_save_dir=./results
base_log_dir=./slurm_logs
behaviors_path=./data/behavior_datasets/harmbench_behaviors_text_val.csv
methods=("GCG" "EnsembleGCG" "PAIR" "AutoDAN")
experiments=("llama2_7b")


for method_name in "${methods[@]}"; do
    for experiment_name in "${experiments[@]}"; do
        save_dir="$base_save_dir/$method_name/$experiment_name/test_cases"
        job_name="merge_test_cases_${method_name}_${experiment_name}"
        log_path="$base_log_dir/merge_test_cases/${method_name}_${experiment_name}.log"

        # Call sbatch with arguments
        sbatch --partition=$partition --job-name=$job_name --nodes=1 --gpus-per-node=0 --time=0:10:00 --output=$log_path \
            scripts/merge_test_cases.sh $method_name $save_dir
    done
done