export CUDA_VISIBLE_DEVICES=0

# Make sure your environment has enough GPUs for the classifier (Llama 2 13B)
base_save_dir="results_ft"

method_name="EnsembleGCG"
# Often, the experiment name will be the same as the model name. It can be different for transfer attacks.
experiment_name="llama2_7b" 
model_name="llama2_7b" 
cls_path="cais/HarmBench-Llama-2-13b-cls"


for k in inter_new_l20 
do
    id="standard_${k}_dev"
    behaviors_path="./data/behavior_datasets/harmbench_behaviors_text_val.csv"
    completions_path="${base_save_dir}/${method_name}/${experiment_name}/completions/${model_name}_${id}.json" # output file from Step 2
    save_path="${base_save_dir}/${method_name}/${experiment_name}/results/${model_name}_${id}.json"

    ./scripts/evaluate_completions.sh $cls_path $behaviors_path $completions_path $save_path

    id="standard_${k}_test"
    behaviors_path="./data/behavior_datasets/harmbench_behaviors_text_test.csv"
    completions_path="${base_save_dir}/${method_name}/${experiment_name}/completions/${model_name}_${id}.json" # output file from Step 2
    save_path="${base_save_dir}/${method_name}/${experiment_name}/results/${model_name}_${id}.json"

    ./scripts/evaluate_completions.sh $cls_path $behaviors_path $completions_path $save_path
done

