theory question_89_10
imports Main

begin

typedecl entity
typedecl event
typedecl time

consts
  Triceps :: "entity ⇒ bool"
  ArmDay :: "time ⇒ bool"
  Contract :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Contracting :: "event ⇒ bool"
  Contract_Unique :: "entity ⇒ event ⇒ event ⇒ bool"

(* Explanation 1: The tricep is a muscle that can contract during arm day and remains in a non-contracted state at all other times. *)
axiomatization where
  explanation_1: "∀x e d. Triceps x ∧ ArmDay d ∧ Contract e ∧ Agent e x ∧ (∀e' d'. Contract e' ∧ Agent e' x ∧ ¬ArmDay d' ⟶ e ≠ e')"

(* Explanation 2: The tricep muscle is capable of contracting, but it only does so during arm day. *)
axiomatization where
  explanation_2: "∀x e d. Triceps x ∧ ArmDay d ∧ Contracting e ∧ Agent e x ∧ (∀e' d'. Contracting e' ∧ Agent e' x ∧ ¬ArmDay d' ⟶ e ≠ e')"

(* Definition for Contract_Unique *)
definition Contract_Unique_def :: "entity ⇒ event ⇒ event ⇒ bool" where
  "Contract_Unique_def x e e' ≡ Contract e ∧ Agent e x ∧ Contract e' ∧ Agent e' x ⟶ e = e'"

(* Contract_Unique is a new predicate, so it needs to be added to the consts *)
consts
  Contract_Unique :: "entity ⇒ event ⇒ event ⇒ bool"

theorem hypothesis:
  assumes asm: "Triceps x"
  (* Hypothesis: Triceps can only contract. *)
  shows "∃e e'. Contract_Unique x e e'"
proof -
  from asm have "Triceps x" by simp
  then obtain e d where e: "Contract e ∧ Agent e x ∧ ArmDay d"
    and d: "∀e' d'. Contract e' ∧ Agent e' x ∧ ¬ArmDay d' ⟶ e ≠ e'"
    using explanation_1 by blast
  then have "Contract_Unique x e e" using Contract_Unique_def by blast
  show ?thesis using asm e by blast
qed

end
