theory question_30_1

imports Main

begin

typedecl entity
typedecl event

consts
  Skateboard :: "entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  Human :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Performing :: "event ⇒ entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Being :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A skateboard is an entity. *)
axiomatization where
  explanation_1: "∀x. Skateboard(x)"

(* Explanation 2: Doing tricks is an event. *)
axiomatization where
  explanation_2: "∃e. DoingTricks(e)"

(* Explanation 3: A human doing tricks is an event. *)
axiomatization where
  explanation_3: "∃x e. Human(x) ∧ DoingTricks(e) ∧ Agent(e, x)"

(* Explanation 4: An agent performing an action on a skateboard is an event. *)
axiomatization where
  explanation_4: "∃x y e. Agent(x) ∧ Skateboard(y) ∧ Performing(e) ∧ On(e, y) ∧ Agent(e, x)"

(* Explanation 5: Being on a skateboard is an event. *)
axiomatization where
  explanation_5: "∃x e. Skateboard(x) ∧ Being(e) ∧ On(e, x)"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x  ∧ Skateboard y  ∧ DoingTricks e  ∧ Agent e  x  ∧ On e  y "
  (* Hypothesis: A human doing tricks is an event. *)
  shows "∃x e. Human x  ∧ DoingTricks e  ∧ Agent e  x "
proof -
  from premise have "Man x" by blast
  from premise have "Skateboard y" by blast
  from premise have "DoingTricks e" by blast
  from explanation_2 have "DoingTricks is an event" by blast
  from explanation_3 have "A human doing tricks is an event" by blast
  show ?thesis using `Man x` `Skateboard y` `DoingTricks e` by blast
qed

end
