theory question_83_2

imports Main

begin

typedecl entity
typedecl event

consts
  Computers :: "entity ⇒ bool"
  ElectricalCircuit :: "entity ⇒ bool"
  WorkingProperly :: "entity ⇒ bool"
  ConnectedTo :: "event ⇒ entity ⇒ entity ⇒ bool"
  Run :: "event ⇒ bool"

(* Explanation 1: Computers will only run when the electrical circuit they are connected to is working properly. *)
axiomatization where
  explanation_1: "∀x y z e. Computers x ∧ ElectricalCircuit y ∧ WorkingProperly z ∧ ConnectedTo e x y ⟶ Run e ∧ ConnectedTo e x y ∧ WorkingProperly y"

(* Explanation 2: Computers connected to an electrical circuit that is working properly will run. *)
axiomatization where
  explanation_2: "∀x y z e. Computers x ∧ ElectricalCircuit y ∧ WorkingProperly z ∧ ConnectedTo e x y ⟶ Run e"

theorem hypothesis:
  assumes asm: "Computers x ∧ ElectricalCircuit y ∧ WorkingProperly y"
  (* Hypothesis: Computers run when electrical circuit is working properly. *)
  shows "∃x y e. Computers x ∧ ElectricalCircuit y ∧ WorkingProperly y ∧ Run e ∧ ConnectedTo e x y"
proof -
  from asm have "Computers x ∧ ElectricalCircuit y ∧ WorkingProperly y" by simp
  then have "ConnectedTo e x y" using explanation_1 by blast
  then have "Run e" using explanation_1 by blast
  have conclusion: "Computers x ∧ ElectricalCircuit y ∧ WorkingProperly y ∧ Run e ∧ ConnectedTo e x y" using asm `Run e` by simp
  show ?thesis using conclusion by blast
qed

end
