theory question_66_0
imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Stars :: "entity ⇒ bool"
  Hot :: "entity ⇒ bool"
  Hottest :: "entity ⇒ bool"

(* Explanation 1: the Sun is a kind of star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: stars are some of the hottest objects. *)
axiomatization where
  explanation_2: "∀x. Stars x ⟶ Hot x"

theorem hypothesis:
  assumes asm: "Sun x ∧ Hottest Sun"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "Hottest Sun"
proof -
  from asm have "Sun x" by simp
  then have "Star x" using explanation_1 by blast
  then have "Hot x" using explanation_2 by blast
  then have "Hottest Sun" using asm by simp
  then show ?thesis by simp
qed

end
