theory question_20_0

imports Main

begin

typedecl entity
typedecl event

consts
  Hair :: "entity ⇒ bool"
  Fiber :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Fur :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Hair is a fiber that is found only in mammals. *)
axiomatization where
  explanation_1: "∀x y. Hair x ∧ Fiber y ⟶ (∃e. Found e ∧ Agent e x ∧ Patient e y ∧ Mammals x)"

(* Explanation 2: All mammals have fur or hair. *)
axiomatization where
  explanation_2: "∀x. Mammals x ⟶ (∃y. Fur y ∧ Has x y) ∨ (∃z. Hair z ∧ Has x z)"

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "∃y. Has x y ∧ Fur y" by auto
  then obtain y where y: "Has x y ∧ Fur y" by blast
  have "Mammals x" using y explanation_2 by blast
  then show ?thesis using asm y by blast
qed

end
