theory question_81_9

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  PopulationSize :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  SuddenReduction :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occur :: "event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ∧ PopulationSize y ⟶ (∃e1. Cause e1 ∧ Agent e1 x ∧ Patient e1 y) ∧ (∃e2. SuddenReduction e2 ∧ Agent e2 e1 ∧ Patient e2 y)"

(* Explanation 2: If a sudden reduction in the population size of a specific entity occurs, then the bottleneck effect occurs in that entity. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Entity y ∧ PopulationSize y ∧ SuddenReduction e1 ∧ Agent e1 y ⟶ (∃e2. BottleneckEffect e2 ∧ Occur e2 ∧ Agent e2 y ∧ Patient e2 y)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  have "Entity y ∧ PopulationSize y" for y
    by (metis asm Entity_def PopulationSize_def)
  then obtain e1 where e1: "Cause e1 ∧ Agent e1 x ∧ Patient e1 y"
    and e2: "SuddenReduction e2 ∧ Agent e2 e1 ∧ Patient e2 y"
    using explanation_1 by blast
  then have "BottleneckEffect e3 ∧ Occur e3 ∧ Agent e3 y ∧ Patient e3 y"
    using explanation_2 by blast
  then obtain e where "BottleneckEffect e ∧ Occur e ∧ Agent e x"
    using e1 by blast
  show ?thesis using e by blast
qed

end
