theory question_77_0

imports Main

begin

typedecl entity

consts
  Most :: "entity ⇒ bool"
  Mollusks :: "entity ⇒ bool"
  HasShell :: "entity ⇒ bool"
  Mussels :: "entity ⇒ bool"
  BivalveMollusks :: "entity ⇒ bool"

(* Explanation 1: Most mollusks have shells. *)
axiomatization where
  explanation_1: "∃x. Most x ∧ Mollusks x ⟶ HasShell x"

(* Explanation 2: Mussels are bivalve mollusks. *)
axiomatization where
  explanation_2: "∀x. Mussels x ⟶ BivalveMollusks x"

theorem hypothesis:
  assumes asm: "Mussels x"
  (* Hypothesis: Mussels have a shell. *)
  shows "HasShell x"
proof -
  from asm have "Mussels x" by simp
  then have "BivalveMollusks x" using explanation_2 by blast
  then have "Mollusks x" by blast
  from this have "HasShell x" using explanation_1 by blast
  show ?thesis using asm by blast
qed

end
