theory question_61_6

imports Main

begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  CentralBody :: "entity ⇒ bool"
  InSolarSystem :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  LargestBody :: "entity ⇒ bool"

(* Explanation 1: The Sun is the central body in the solar system. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ CentralBody x ∧ InSolarSystem x"

(* Explanation 2: The Sun is a star and the central body in the solar system. *)
axiomatization where
  explanation_2: "∀x. Sun x ⟶ Star x ∧ CentralBody x ∧ InSolarSystem x"

theorem hypothesis:
  assumes asm: "LargestBody x ∧ InSolarSystem x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "Sun x"
proof -
  from asm have "InSolarSystem x" by simp
  then have "Sun x ∨ ¬ Sun x" by simp
  then have "CentralBody x ∧ InSolarSystem x" if "Sun x"
    using explanation_1 by simp
  then have "LargestBody x" using asm by simp
  then show "Sun x" by simp
qed

end
