theory question_53_1

imports Main

begin

typedecl entity

consts
  Moon :: "entity"
  Earth :: "entity"
  LessWaterAndAir :: "entity ⇒ entity ⇒ bool"
  LowerWaterOrAirContent :: "entity ⇒ bool"
  DrierConditions :: "entity ⇒ bool"

(* Explanation 1: The Moon has less water and air than Earth. *)
axiomatization where
  explanation_1: "LessWaterAndAir Moon Earth"

(* Explanation 2: Lower water or air content implies drier conditions. *)
axiomatization where
  explanation_2: "LowerWaterOrAirContent x ⟶ DrierConditions x"

theorem hypothesis:
  assumes asm: "LessWaterAndAir Moon Earth"
  (* Hypothesis: The Moon has less water and air than Earth. *)
  shows "DrierConditions Moon"
proof -
  have "LessWaterAndAir Moon Earth" by fact (asm)
  then have "LowerWaterOrAirContent Moon" by (rule explanation_1)
  then have "DrierConditions Moon" by (rule explanation_2)
  then show ?thesis by simp
qed

end
