theory question_20_0
imports Main

begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Gravity :: "entity ⇒ bool"
  Orbits :: "entity ⇒ entity ⇒ event ⇒ bool"
  Causes :: "entity ⇒ event ⇒ bool"
  PulledDown :: "entity ⇒ entity ⇒ event ⇒ bool"
  HasMass :: "entity ⇒ bool"
  GravitationalForce :: "entity ⇒ entity ⇒ event"
  Planets :: "entity ⇒ bool"
  Stars :: "entity ⇒ bool"

(* Explanation 1: the Sun is a kind of star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: gravity causes orbits. *)
axiomatization where
  explanation_2: "∀e. Orbits(x, y, e) ⟶ Causes(Gravity, e)"

(* Explanation 3: gravity; gravitational force causes objects that have mass; substances to be pulled down; to fall on a planet. *)
axiomatization where
  explanation_3: "∀e. PulledDown(x, y, e) ∧ HasMass(x) ⟶ Causes(GravitationalForce(gravity, x), e)"

(* Explanation 4: planets orbit stars. *)
axiomatization where
  explanation_4: "∀x y. Planets x ∧ Stars y ⟶ (∃e. Orbits(x, y, e))"

theorem hypothesis:
  (* Premise: when isaac newton theorized that gravity caused objects to fall to the ground. *)
  assumes asm: "Theorized isaac_newton Gravity_causes_falling_to_ground e"
  (* Hypothesis: He had also discovered the force that causes the planets to orbit the Sun. *)
  shows "∃e. Discovered isaac_newton  GravitationalForce gravity  the_Sun   e ∧  ∀x. Planets x ∧ Orbits x  the_Sun  e   ∧ Causes  GravitationalForce gravity  the_Sun   e "
proof -
  from asm have "Causes Gravity e" by simp
  then have "∃e. Discovered isaac_newton GravitationalForce gravity the_Sun e ∧ ∀x. Planets x ⟶ Orbits x the_Sun e ∧ Causes GravitationalForce gravity the_Sun e"
    using explanation_3 explanation_4 by blast
  then show ?thesis by blast
qed

end
