theory question_10_7

imports Main

begin

typedecl entity
typedecl event

consts
  Plants :: "entity ⇒ bool"
  Green :: "entity ⇒ bool"
  Leaves :: "entity ⇒ bool"
  Adaptation :: "entity ⇒ bool"
  AbsorbingSunlight :: "entity ⇒ bool"
  Shape :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Value :: "entity ⇒ entity ⇒ bool"
  RainyClimate :: "entity ⇒ bool"
  SurviveWell :: "entity ⇒ entity ⇒ bool"
  Wide :: "entity ⇒ bool"
  Flat :: "entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Plants x ∧ Leaves y ∧ RainyClimate x ∧ SurviveWell y x"
  (* Hypothesis: The shape of plants' leaves that survive well in a rainy climate are most often wide and flat. *)
  shows "Wide y ∧ Flat y"
proof -
  from asm have "RainyClimate x" by simp
  then have "SurviveWell y x" by simp
  then have "Wide y ∧ Flat y" using SurviveWell_rainy by blast
  then show ?thesis by simp
qed

end
