theory question_17_0
imports Main

begin

typedecl entity
typedecl event

consts
  Consumers :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Agent :: "entity ⇒ event ⇒ bool" (* updated type for Agent constant *)
  TrophicLevel :: "entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Plants :: "entity ⇒ bool"
  Producer :: "entity ⇒ bool"
  Omnivores :: "entity ⇒ bool"

(* Explanation 1: Many consumers feed at more than one trophic level. *)
axiomatization where
  explanation_1: "∃x. Consumers x ∧ (∃e y1 y2. Feed e ∧ Agent e x ∧ TrophicLevel y1 ∧ TrophicLevel y2 ∧ Patient e y1 ∧ Patient e y2 ∧ y1 ≠ y2)"

(* Explanation 2: Plants are producers, they are also consumers, and they can be omnivores too. *)
axiomatization where
  explanation_2: "∀x. Plants x ⟶ (Producer x ∧ Consumers x ∧ (∃y. Omnivores y ∧ Agent y x))" (* updated Agent usage *)

theorem hypothesis:
  assumes asm: "Omnivores x"
  shows "∃e y1 y2. Feed e ∧ Agent x e ∧ TrophicLevel y1 ∧ TrophicLevel y2 ∧ Patient e y1 ∧ Patient e y2 ∧ y1 ≠ y2"
proof -
  from asm have "Consumers x" using explanation_2 by simp
  then obtain e y1 y2 where "Feed e" "Agent x e" "TrophicLevel y1" "TrophicLevel y2" "Patient e y1" "Patient e y2" "y1 ≠ y2" using explanation_1 by blast
  then show ?thesis using asm e y1 y2 by blast
qed

end
