theory question_86_0
imports Main

begin

typedecl entity
typedecl event

consts
  Women :: "entity ⇒ bool"
  Talking :: "event ⇒ bool"
  Table :: "entity ⇒ bool"
  Drinks :: "entity ⇒ bool"
  Conversing :: "event ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation: There are three woman conversing at a table with drinks. *)
axiomatization where
  explanation: "∃x y z e. Women x ∧ #(x) = 3 ∧ Table y ∧ Drinks z ∧ Conversing e ∧ Agent e x ∧ At x y ∧ With x z"

theorem hypothesis:
  (* Premise: There are three woman conversing at a table with drinks. *)
  assumes asm: "Women x ∧ # x  = 3 ∧ Table y ∧ Drinks z ∧ Conversing e ∧ Agent e x ∧ At x y ∧ With x z"
  (* Hypothesis: Women are talking. *)
  shows "∃x. Women x ∧ Talking e' ∧ Agent e' x"
proof -
  from asm have "Women x ∧ Conversing e ∧ Agent e x ∧ At x y ∧ With x z" by blast
  then have "Women x ∧ Talking e' ∧ Agent e' x" using explanation by blast
  then show ?thesis using asm by blast
qed

end
