theory question_29_3

imports Main

begin

typedecl entity
typedecl event

consts
  Wearing :: "entity ⇒ bool"
  Makeup :: "entity ⇒ bool"
  WearingMakeup :: "entity ⇒ bool"
  Men :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  WearingRedMakeup :: "entity ⇒ bool"
  Face :: "entity ⇒ bool"
  MakeupOnFace :: "entity ⇒ entity ⇒ bool"
  OnFace :: "event ⇒ entity ⇒ bool"
  Costume :: "entity ⇒ bool"
  OlderMan :: "entity ⇒ bool"
  Cream :: "entity ⇒ bool"
  Background :: "entity ⇒ bool"
  Displays :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: ∀w v. Wearing(w) ⟶ Makeup(v) ⟶ WearingMakeup(w) *)
axiomatization where
  explanation_1: "∀w v. Wearing w ⟶ Makeup v ⟶ WearingMakeup w"

(* Explanation 2: ∀x. Men(x) ⟶ ∃y. WearingMakeup(y) ∧ Agent(y, x) *)
axiomatization where
  explanation_2: "∀x. Men x ⟶ ∃y. WearingMakeup y ∧ Agent y x"

(* Explanation 3: ∀w v. WearingRedMakeup(w) ∧ Face(v) ⟶ MakeupOnFace(w, v) *)
axiomatization where
  explanation_3: "∀w v. WearingRedMakeup w ∧ Face v ⟶ MakeupOnFace w v"

(* Explanation 4: ∃x y z. Men(x) ∧ Men(y) ∧ WearingRedMakeup(z) ∧ Agent(z, x) ∧ Agent(z, y) ∧ OnFace(z, x) ∧ OnFace(z, y) *)
axiomatization where
  explanation_4: "∃x y z. Men x ∧ Men y ∧ WearingRedMakeup z ∧ Agent z x ∧ Agent z y ∧ OnFace z x ∧ OnFace z y"

theorem hypothesis:
  (* Premise: ∃x y z w. Festival(w) ∧ Men(x) ∧ Men(y) ∧ Dressed(e) ∧ Agent(e, x) ∧ Agent(e, y) ∧ RedMakeup(z) ∧ On(z, x) ∧ On(z, y) ∧ Costume(t) ∧ Agent(e, t) ∧ OlderMan(u) ∧ Cream(r) ∧ On(r, u) ∧ NotRedMakeup(r) ∧ Background(b) ∧ Displays(w, x) ∧ Displays(w, y) ∧ Displays(w, z) ∧ Displays(w, u) ∧ Displays(w, b) *)
  assumes asm: "Festival w ∧ Men x ∧ Men y ∧ Dressed e ∧ Agent e x ∧ Agent e y ∧ RedMakeup z ∧ On z x ∧ On z y ∧ Costume t ∧ Agent e t ∧ OlderMan u ∧ Cream r ∧ On r u ∧ NotRedMakeup r ∧ Background b ∧ Displays w x ∧ Displays w y ∧ Displays w z ∧ Displays w u ∧ Displays w b"
  (* Hypothesis: ∃x y. Men(x) ∧ Men(y) ∧ Dressed(e) ∧ Agent(e, x) ∧ Agent(e, y) ∧ Makeup(z) ∧ On(z, x) ∧ On(z, y) *)
  shows "∃x y. Men x ∧ Men y ∧ Dressed e ∧ Agent e x ∧ Agent e y ∧ Makeup z ∧ On z x ∧ On z y"
proof -
  from asm have "RedMakeup z" by fastforce
  then have "Makeup z" by simp
  from asm have "Agent e x" "Agent e y" by fastforce
  from asm have "Dressed e" by simp
  from asm have "Men x" "Men y" by simp
  from asm have "On z x" "On z y" by fastforce
  from asm have "Festival w" "Displays w x" "Displays w y" "Displays w z" by fastforce
  from explanation_4 have "∃e'. Men x' ∧ Men y' ∧ WearingRedMakeup z' ∧ Agent z' x' ∧ Agent z' y' ∧ OnFace z' x' ∧ OnFace z' y'" by simp
  from this(1) asm(5,6) have "OnFace z x" "OnFace z y" by blast
  from this(1) have "WearingRedMakeup z" by simp
  from this(1) have "MakeupOnFace z x" "MakeupOnFace z y" by simp
  from this(2) have "Makeup z" by simp
  show ?thesis using asm(3,4) this(3,4,5,6) by blast
qed

end
