theory question_27_1

imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Dirty :: "entity ⇒ bool"

(* Explanation: If a man is old, then he can be assumed to be an older man. *)
axiomatization where
  explanation: "∀x. Man x ∧ Old x ⟶ OlderMan x"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Man x ∧ Old x ∧ HardwareParts y ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ Sidewalk z ∧ On x z ∧ Dirty z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "Sidewalk z ∧ On x z ∧ Dirty z" by blast
  then have "Outside x" using explanation by blast
  then show ?thesis using asm by blast
qed

end
