theory question_63_0
imports Main

begin

typedecl entity
typedecl event
typedecl time

consts
  FossilsOfWaterAnimalOrPlant :: "entity ⇒ bool"
  Place :: "entity ⇒ bool"
  Found :: "entity ⇒ entity ⇒ bool"
  Time :: "time ⇒ bool"
  Past :: "time ⇒ bool"
  CoveredByWater :: "entity ⇒ time ⇒ bool"
  Trilobite :: "entity ⇒ bool"
  WaterAnimal :: "entity ⇒ bool"
  Ohio :: "entity ⇒ bool"
  State :: "entity ⇒ bool"
  LocatedIn :: "entity ⇒ entity ⇒ bool"
  Country :: "entity ⇒ bool"
  UnitedStatesOfAmerica :: "entity ⇒ bool"
  Extinct :: "entity ⇒ bool"
  SeaAnimal :: "entity ⇒ bool"

(* Explanation 1: if fossils of a water animal or plant are found in a place then that place used to be covered by water in the past. *)
axiomatization where
  explanation_1: "∀x y t. FossilsOfWaterAnimalOrPlant x ∧ Place y ∧ Found x y ∧ Time t ∧ Past t ⟶ [CoveredByWater y t]"

(* Explanation 2: a trilobite is a kind of water animal. *)
axiomatization where
  explanation_2: "∀x. Trilobite x ⟶ WaterAnimal x"

(* Explanation 3: Ohio is a state located in the United States of America. *)
axiomatization where
  explanation_3: "∃o c. Ohio o ∧ State o ∧ LocatedIn o c ∧ Country c ∧ UnitedStatesOfAmerica c"

(* Explanation 4: a state is a kind of place. *)
axiomatization where
  explanation_4: "∀x. State x ⟶ Place x"

theorem hypothesis:
  (* Premise: the fossils of extinct sea animals called trilobites are found in ohio. *)
  assumes asm: "Trilobite x ∧ Extinct x ∧ SeaAnimal x ∧ FossilsOfWaterAnimalOrPlant x ∧ Found x Ohio"
  (* Hypothesis: Ohio was once covered by water. *)
  shows "∃t. [Ohio o] ∧ Time t ∧ Past t ∧ CoveredByWater o t"
proof -
  {
    assume asm: "Trilobite x ∧ Extinct x ∧ SeaAnimal x ∧ FossilsOfWaterAnimalOrPlant x ∧ Found x Ohio"
    from asm have "FossilsOfWaterAnimalOrPlant x" by simp
    from asm have "Found x Ohio" by simp
    from asm have "Trilobite x" by simp
    from ‹Trilobite x› have "WaterAnimal x" using explanation_2 by blast
    from ‹WaterAnimal x› have "Place x" using explanation_4 by blast
    from ‹Place x› have "Place Ohio" using explanation_4 by blast
    from ‹FossilsOfWaterAnimalOrPlant x› ‹Place Ohio› ‹Found x Ohio› have "∃t. Past t ∧ CoveredByWater Ohio t" using explanation_1 by blast
    then have "∃t. [∃o. Ohio o] ∧ Time t ∧ Past t ∧ CoveredByWater o t" using asm by blast
  }
  then show ?thesis by blast
qed

end
