theory question_75_6

theory Friction_Slowing_Down
  imports
    Physical_Interactions.Motion
    Physical_Interactions.Surface
    Physical_Interactions.Friction
begin

definition "slowing_down" := λx, ¬ accelerating x

axiomatization where
  slowing_down: ∀x, slowing_down x ↔ ¬ accelerating x

theorem "friction_slowing_down" : ∀x y, friction x y ∧ slowing_down x ↔ ¬ accelerating y
proof -
  from asm have "slowing_down x" by simp
  then obtain e1 where e1: "friction x y ∧ slowing_down x" using explanation_2 by blast
  then have "contact x y" using explanation_3 by blast
  then have "surface x" using explanation_4 by blast
  then have "object x" using explanation_5 by blast
  then have "motion x" using explanation_6 by blast
  then have "pushing x y ∨ pulling x y" using explanation_8 by blast
  then have "rolling x" using explanation_9 by blast
  then have "ball x" using explanation_10 by blast
  then have "force e1" using explanation_11 by blast
  then show ?thesis using asm e1 by simp
qed

end
