theory question_81_8

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  Event :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  GetsSmaller :: "event ⇒ bool"
  DueTo :: "event ⇒ entity ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  Cause :: "event ⇒ entity ⇒ entity ⇒ bool"
  Triggers :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller due to an event. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. BottleneckEffect x ∧ Population y ∧ Event z ∧ Occurs e1 ∧ Agent e1 x ∧ GetsSmaller e2 ∧ Agent e2 y ∧ DueTo e2 z"

(* Explanation 2: External migration is an event that can cause a population to suddenly get much smaller and directly triggers the bottleneck effect. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3. ExternalMigration x ∧ Population y ∧ BottleneckEffect z ∧ Event x ∧ Cause e1 x y ∧ GetsSmaller e2 ∧ Agent e2 y ∧ Triggers e3 x z"

(* Explanation 3: When external migration occurs, it triggers the bottleneck effect. *)
axiomatization where
  explanation_3: "∀x y e1 e2. ExternalMigration x ∧ BottleneckEffect y ∧ Occurs e1 ∧ Agent e1 x ⟶ Triggers e2 x y"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e ∧ Agent e x ∧ Agent e y"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain e1 where e1: "Occurs e1 ∧ Agent e1 x" using explanation_1 by blast
  then have "Occurs e1 ∧ Agent e1 y" using explanation_2 by blast
  have conclusion: "Occurs e1 ∧ Agent e1 x ∧ Agent e1 y" using e1 by simp
  show ?thesis using asm conclusion by blast
qed

end
