theory question_93_2
imports Main

begin
typedecl entity
typedecl event

consts
  TwoLambs :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  OldWoman :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Broom :: "entity ⇒ bool"
  Chasing :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  With :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Two lambs are animals. *)
axiomatization where
  explanation_1: "∀x. TwoLambs x ⟶ Animals x"

(* Explanation 2: An old woman is a woman. *)
axiomatization where
  explanation_2: "∀x. OldWoman x ⟶ Woman x"

theorem hypothesis:
  (* Premise: Old woman chasing away two lambs with a broom. *)
  assumes asm: "OldWoman x ∧ TwoLambs y ∧ Broom z ∧ Chasing e y ∧ Agent e x ∧ Patient e y ∧ With e z"
  (* Hypothesis: There is a woman and some animals. *)
  shows "∃x y. Woman x ∧ Animals y"
proof -
  from asm have "OldWoman x" by blast
  from this have "Woman x" using explanation_2 by blast
  from asm have "TwoLambs y" by blast
  from this have "Animals y" using explanation_1 by blast
  show ?thesis using `Woman x` `Animals y` by blast
qed

end
