theory question_7_0

imports Main

begin
typedecl entity
typedecl event

consts
  Girl :: "entity ⇒ bool"
  Rope :: "entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Little :: "entity ⇒ bool"
  Yellow :: "entity ⇒ bool"
  JumpingOver :: "event ⇒ bool"

(* Explanation 1: jumping over a yellow rope is same as jumps rope. *)
axiomatization where
  explanation_1: "∀x y e. Yellow y ∧ Rope y ∧ JumpingOver e ∧ Agent e x ∧ Patient e y ⟷ Jumps e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A little girl is jumping over a yellow rope. *)
  assumes asm: "Little x ∧ Girl x ∧ Yellow y ∧ Rope y ∧ JumpingOver e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A girl jumps rope. *)
  shows "∃x y e. Girl x ∧ Rope y ∧ Jumps e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Girl x ∧ Yellow y ∧ Rope y ∧ JumpingOver e ∧ Agent e x ∧ Patient e y" by blast
  then have "Girl x ∧ Rope y ∧ Jumps e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
