theory question_63_1
imports Main

begin

typedecl entity
typedecl event

consts
  WaterAnimal :: "entity ⇒ bool"
  Plant :: "entity ⇒ bool"
  FossilsOf :: "event ⇒ entity ⇒ bool"
  Place :: "entity ⇒ bool"
  CoveredByWater :: "entity ⇒ event ⇒ bool"
  Trilobite :: "entity ⇒ bool"
  State :: "entity ⇒ bool"
  LocatedIn :: "entity ⇒ entity ⇒ bool"
  UnitedStatesOfAmerica :: "entity"
  Ohio :: "entity"

(* Explanation 1: if fossils of a water animal or plant are found in a place then that place used to be covered by water in the past. *)
axiomatization where
  explanation_1: "∀x y e. WaterAnimal x ∨ Plant y ∧ FossilsOf e x ∨ FossilsOf e y ⟶ (∃z. Place z ∧ CoveredByWater z e)"

(* Explanation 2: a trilobite is a kind of water animal. *)
axiomatization where
  explanation_2: "∀x. Trilobite x ⟶ WaterAnimal x"

(* Explanation 3: Ohio is a state located in the United States of America. *)
axiomatization where
  explanation_3: "State Ohio ⟶ LocatedIn(Ohio, UnitedStatesOfAmerica)"

(* Explanation 4: a state is a kind of place. *)
axiomatization where
  explanation_4: "∀x. State x ⟶ Place x"

theorem hypothesis:
  (* Premise: the fossils of extinct sea animals called trilobites are found in ohio. *)
  assumes asm: "Trilobite e ∧ FossilsOf e Ohio"
  (* Hypothesis: Ohio was once covered by water. *)
  shows "∃e. Ohio ∧ CoveredByWater Ohio e"
proof -
  from asm have "Trilobite e" by simp
  then have "WaterAnimal e" using explanation_2 by blast
  from asm have "FossilsOf e Ohio" by simp
  then have "∃z. Place z ∧ CoveredByWater z e" using explanation_1 `WaterAnimal e` by blast
  then obtain z where z: "Place z ∧ CoveredByWater z e" by blast
  have "State Ohio" using explanation_4 z by blast
  then have "Place Ohio" using explanation_4 by blast
  then have "Ohio ∧ CoveredByWater Ohio e" using z by blast
  then show ?thesis using `Ohio ∧ CoveredByWater Ohio e` by blast
qed

end
