theory question_89_7

imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  Bicycling :: "entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  EarlyFall :: "entity ⇒ bool"
  
(* Explanation 1: Mountain biking is a form of bicycling. *)
axiomatization where
  explanation_1: "∀x. MountainBiking x ⟶ Bicycling x"

(* Explanation 2: Woods are synonymous with forests. *)
axiomatization where
  explanation_2: "∀x. Woods x ⟶ Forest x"

(* Explanation 3: Autumn is another term for the early fall. *)
axiomatization where
  explanation_3: "∀x. Autumn x ⟶ EarlyFall x"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking e ∧ Forest x ∧ EarlyFall y ∧ In x y ∧ In x z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Bicycling e ∧ Woods x ∧ Autumn y ∧ In x y ∧ In x z"
proof -
  from asm have "MountainBiking e" by blast
  from asm have "Forest x" by blast
  from asm have "EarlyFall y" by blast
  from explanation_1 and `MountainBiking e` have "Bicycling e" by blast
  from explanation_2 and `Forest x` have "Woods x" by blast
  from explanation_3 and `EarlyFall y` have "Autumn y" by blast
  show ?thesis using `Bicycling e` `Woods x` `Autumn y` by blast
qed

end
