theory question_46_7
imports Main
begin

typedecl entity
typedecl event

consts
  Fruit :: "entity ⇒ bool"
  StreetCart :: "entity ⇒ bool"
  Selling :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  StreetVendor :: "entity ⇒ bool"
  Boy :: "entity ⇒ bool"
  OrangeShirt :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Selling fruit from a street cart implies being a street vendor. *)
axiomatization where
  explanation_1: "∀x y e. Fruit y ∧ StreetCart x ∧ Selling e ∧ Agent e x ∧ Patient e y ⟶ StreetVendor x"

theorem hypothesis:
  (* Premise: A boy in an orange shirt sells fruit from a street cart. *)
  assumes asm: "Boy x ∧ OrangeShirt z ∧ StreetCart y ∧ Selling e ∧ Agent e x ∧ Patient e y ∧ Wearing x z"
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x. Boy x ∧ StreetVendor x"
proof -
  from asm have "Boy x ∧ StreetCart y ∧ Selling e ∧ Agent e x ∧ Patient e y" by blast
  from this and explanation_1 have "StreetVendor y" by blast
  then show ?thesis using asm by blast
qed

end
