import os
import json
import argparse

import openpyxl

from glob import glob

import openpyxl.workbook

from visarg.others.eval_con import eval_con

PROMPTING = {
    '0': 'I -> C',
    '1': 'I, VP -> C',
    '2': 'I, CP -> C',
    '3': 'I, VP, CP -> C',
    '4': 'I, VP, CP, RS -> C',
    'ia': 'VP(all), CP(pos) -> IC',
    'ip': 'VP(pos), CP(pos) -> IC',
}

def write_eval_con_excel(model_names: list, metrics: list, data_names: list, results_path: str, output_path: str, is_ic_deduction: bool):
    # Get Evaluation Results
    results = {
        key: {
            model: {} for model in model_names
        } for key in data_names
    }
    
    for model in model_names:
        for data in data_names:
            if is_ic_deduction:
                gts = sorted(glob(os.path.join(results_path, f'{model}_*_{data}_gts*.json')))
                res = sorted(glob(os.path.join(results_path, f'{model}_*_{data}_res*.json')))
            else:
                gts = sorted(glob(os.path.join(results_path, f'{model}_*_{data}_gts.json')))
                res = sorted(glob(os.path.join(results_path, f'{model}_*_{data}_res.json')))

            for g, r in zip(gts, res):
                prompting_num = g.split(f'{model}_')[-1][0]
                if is_ic_deduction and '_ic_' in r:
                    prompting_num += r.split('res_')[-1][0]
                results[data][model][prompting_num] = eval_con(gts=g, res=r, metrics=metrics)
    
    # Make Excel File        
    workbook = openpyxl.Workbook()
    sheet = workbook.active
    try:
        metrics.remove('bleu:4')
        metrics = ['bleu:1', 'bleu:2', 'bleu:3', 'bleu:4'] + metrics
    except:
        pass
    header = ["data", "model", "condition"] + metrics
    sheet.append(header)

    # Append rows
    for data in data_names:
        for model, pr_result in results[data].items():
            rows = []
            for pr_num, result in pr_result.items():
                row = [data, model, PROMPTING[pr_num]]
                for metric, value in result.items():
                    if 'bleu' == metric:
                        row.extend([str(value[0][0]*100), str(value[0][1]*100), str(value[0][2]*100), str(value[0][3]*100)])
                    else:
                        row.append(str(value[0]))
                rows.append(row)
                
            for row in rows:
                sheet.append(row)
            
    workbook.save(output_path)
    print()
    print("==============================================")
    print(f"Evaluation Results save to {output_path}")
    print("==============================================")


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    
    parser.add_argument("--model_names", nargs='+', required=True)
    parser.add_argument("--metrics", nargs='+', required=True)
    parser.add_argument("--data_names", nargs='+', required=True)
    parser.add_argument("--results_path", type=str, default="./results/task4")
    parser.add_argument("--output_path", type=str, default="./task4_results.xlsx")
    parser.add_argument("--ic_deduction", action="store_true")
    
    args = parser.parse_args()
    
    write_eval_con_excel(
        model_names=args.model_names,
        metrics=args.metrics,
        data_names=args.data_names,
        results_path=args.results_path,
        output_path=args.output_path,
        is_ic_deduction=args.ic_deduction,
    )