#! /bin/bash

source activate your_env



HOME_DIR="./"
model_name=$2 # e.g., aubmindlab/bert-base-arabertv2

while read line
do
	echo $line
	OIFS=$IFS
	IFS=' '
	set -- $line
	array=( $@ )
	train=$HOME_DIR/"arabic_memes_categorization_train.jsonl"
	dev=$HOME_DIR/"arabic_memes_categorization_dev.jsonl"
	tst=$HOME_DIR/"arabic_memes_categorization_test.jsonl"

	END=10
	for ((i=0;i<=END;i++)); do

        #seed=`expr 42 - "$i"`
        seed=`expr 42 - $i`
        echo "hello "$seed
        run="_run_"$i"_"$seed
        fname=`basename $train .tsv`
        tst_fname=`basename $tst .tsv`
        output_file=$HOME_DIR/results/$model_name/$fname/$tst_fname$run".json"
        mkdir -p $HOME_DIR/results/$model_name/$fname/

        export GLUE_DIR=cache
        export TASK_NAME=multiclass
        outputdir=$HOME_DIR/experiments/$model_name/$fname/$run/
        data_dir=$GLUE_DIR/$TASK_NAME/$model_name/$fname/$run/
        mkdir -p $outputdir
        mkdir -p $data_dir
        mkdir -p $outputdir
        mkdir -p $data_dir
        echo "Output dir: "$outputdir
		echo "Model Name: "$model_name
		echo "Pre-trained model cache dir: "$model_cache_dir

        python bin/run_glue.py \
            --model_name_or_path $model_name \
            --train_file $train \
            --validation_file $dev \
            --test_file $tst \
            --out_file $output_file \
            --do_train \
            --do_eval \
            --do_predict \
            --data_dir $data_dir \
            --max_seq_length 512 \
            --per_device_eval_batch_size=8 \
            --per_device_train_batch_size=8 \
            --learning_rate 2e-5 \
            --weight_decay 0.0001 \
            --num_train_epochs 10 \
            --seed $seed \
            --output_dir $outputdir \
            --overwrite_output_dir \
            --cache_dir $data_dir \
			--load_best_model_at_end \
			--save_strategy "epoch" \
			--evaluation_strategy epoch \
			--load_best_model_at_end=True \
			--metric_for_best_model "eval_accuracy" \
			--greater_is_better=True \
			--disable_tqdm=False \
			--save_total_limit 2 \
			--do_train \
			--do_eval \
			--do_predict \
			--logging_strategy "steps"
            
    find $HOME_DIR/experiments/$model_name/$fname -type f -name "pytorch_model.bin" -exec rm -rf {} \;
    find $HOME_DIR/experiments/$model_name/$fname -type f -name "optimizer.pt" -exec rm -rf {} \;
            
    done
done <"$1"

