import glob
import os


def load_context(fpath="eval/needle/PaulGrahamEssays/*.txt", ctx_len=100000):
    context = ""
    for file in glob.glob(fpath):
        with open(file, 'r') as f:
            context += f.read()
    LLAMA_CHAR_TO_TOKEN_RATIO = 3.66
    context = context[: int(ctx_len * LLAMA_CHAR_TO_TOKEN_RATIO)]
    return context


def insert_needle(context, needle, depth):
    context = context.split(".")
    c_len = len(context)
    needle_place = int(depth * c_len)
    context = ".".join(context[:needle_place]) + "." + needle + ".".join(context[needle_place:])
    return context


def get_suffix(skip_layers, keep_ratio, sort_metric):
    if isinstance(skip_layers, list):
        skip_layers = "-".join(skip_layers)
    else:
        assert isinstance(skip_layers, str)
        skip_layers = skip_layers.replace(",", "-")
    keep_ratio = str(int(keep_ratio * 100))
    return f"sort{sort_metric}_skip{skip_layers}_keep{keep_ratio}"
