from pathlib import Path

import requests

current_dir = Path(__file__).resolve().parent


def download_snips_raw_data():
    url = "https://raw.github.com/LeePleased/StackPropagation-SLU/master/data/snips/"
    train_filename = "train.txt"
    test_filename = "test.txt"

    for filename in [train_filename, test_filename]:
        filepath = current_dir / filename
        response = requests.get(url + filename)
        if not filepath.exists():
            with open(filepath, "w") as f:
                f.write(response.text)
            print(f"Downloaded {filename} to {filepath}.")
        else:
            print(f"{filename} already exists at {filepath}.")


if __name__ == "__main__":
    download_snips_raw_data()
