task="story_generation"
lrs=(5e-5)
batch=10
seeds=(5)
device="0"
model="facebook/bart-base"
event_nums=(5)
suffix="gen_with_no_rel_story_input"
root="../output/"
for l in "${lrs[@]}"
do
  for s in "${batch[@]}"
  do
	    for seed in "${seeds[@]}"
	    do
	      for event_num in "${event_nums[@]}"
	      do
        nohup python run_story_generation.py \
        --data_dir "../data/" \
        --model ${model} \
        --save_model \
        --task_name  ${task} \
        --file_suffix "_story_generation_all_complete.json" \
        --device_num ${device} \
        --train_batch_size ${s} \
        --num_train_epochs 10 \
        --max_seq_length 72 \
        --do_train \
        --do_eval \
        --input_event_num ${event_num} \
        --learning_rate ${l} \
        --seed ${seed} \
        --output_dir "${root}/${task}/${model}_batch_${s}_lr_${l}_seed_${seed}_event_${event_num}_${suffix}" \
        > ./logs/${task}/${model}_batch_${s}_lr_${l}_seed_${seed}_event_${event_num}_${suffix}
        done
      done
    done
done