# Copyright (c) Facebook, Inc. and its affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

import numpy as np
import torch

from . import BaseWrapperDataset


class MoveTokenDataset(BaseWrapperDataset):

    def __init__(self, dataset, append_first_token, delete_first_token):
        super().__init__(dataset)
        self.append_first_token = append_first_token
        self.delete_first_token = delete_first_token

    def __getitem__(self, idx):
        item = self.dataset[idx]
        if self.append_first_token:
            item = torch.cat([item, item.new([item[0]])])
        if self.delete_first_token:
            item = item[1:]            
        return item

