import os
import sys

def saveTxt(datas, fname):
    with open(fname, 'w') as fout:
        for data in datas:
            fout.write(data + '\n')
    print("save {} lines to {}".format(len(datas), fname))

datadir = sys.argv[1]
input_name = sys.argv[2]

datas = []

for field in ['q', 'a', 'e']:
    filename = input_name.replace("*", field)
    with open(os.path.join(datadir, filename), 'r') as fin:
        datas.append([line.strip() for line in fin])

results = []

queries = []
answers = []
passages = []
for q, a, e in zip(*datas):
    if q != "" and a != "" and e != "":
        queries.append(q)
        answers.append(a)
        passages.append(e)

saveTxt(queries, os.path.join(
    datadir, input_name.replace('*', 'q') + ".noempty"
))

saveTxt(answers, os.path.join(
    datadir, input_name.replace('*', 'a') + ".noempty"
))

saveTxt(passages, os.path.join(
    datadir, input_name.replace('*', 'e') + ".noempty"
))

