#!/usr/bin/env bash

# for lg in de en fr zh ru
# do
#     for trg in de fr zh ru en
# 	do
# 		python trans/readTrans.py -i ~/data/clean/output/dev.lang5.lead2.2${trg}* -o ~/data/clean/output -r ~/data/clean/$lg/dev.$lg.lead2
# 	done
# done

# for lg in de en fr zh ru
# do
# 	paste -d "|" ~/data/clean/output/dev.$lg.lead2.*  > ~/data/clean/output/dev.$lg.lead2.multi
# done

DIR="/home/tiger/data/clean/output/finish"
LANG="de en fr zh ru"

get_seeded_random()
{
  seed="$1"
  openssl enc -aes-256-ctr -pass pass:"$seed" -nosalt \
    </dev/zero 2>/dev/null
}

cat $DIR/train.de.lead2.multi $DIR/train.en.lead2.multi $DIR/train.fr.lead2.multi $DIR/train.zh.lead2.multi $DIR/train.ru.lead2.multi > $DIR/train.noshuffle.lead2.multi
echo "shuffling"
shuf --random-source=<(get_seeded_random 66) $DIR/train.noshuffle.lead2.multi > $DIR/train.lang5.lead2.multi
cat $DIR/dev.de.lead2.multi $DIR/dev.en.lead2.multi $DIR/dev.fr.lead2.multi $DIR/dev.zh.lead2.multi $DIR/dev.ru.lead2.multi > $DIR/dev.noshuffle.lead2.multi
echo "shuffling"
shuf --random-source=<(get_seeded_random 66) $DIR/dev.noshuffle.lead2.multi > $DIR/dev.lang5.lead2.multi




