import os

from telicity.util import io


class FastTextEmbedding():
	def __init__(self, embedding_path, **kwargs):
		self.X_ = io.hdf_to_numpy(path=embedding_path, name=kwargs.get('embedding_X_name', 'X.hdf'))
		self.inv_idx_ = io.load_structured_resource(os.path.join(embedding_path,
																 kwargs.get('embedding_inv_idx_name',
																			'inverted_index.dill')))

	def __getitem__(self, w):
		return self.X_[self.inv_idx_[w]]

	def __contains__(self, w):
		return w in self.inv_idx_

	def get(self, w, default):
		return self.X_[self.inv_idx_[w]] if w in self.inv_idx_ else default

	def dimensionality(self):
		return self.X_.shape[1]

	def num_vectors(self):
		return self.X_.shape[0]