from transformers import AutoTokenizer, AutoModelForSeq2SeqLM

USE_GPU = True

# download the pre-trained models from the hub
tokenizer = AutoTokenizer.from_pretrained("bigscience/T0_3B")
model = AutoModelForSeq2SeqLM.from_pretrained("bigscience/T0_3B")

# move model from CPU to GPU
if USE_GPU:
    model.cuda()

# map the text to token ids
inputs = tokenizer.encode("Is this paragraph about Up state or Init state? Paragraph: Up state means that the BFD session has successfully been established, and implies that connectivity between the systems is working.  The session will remain in the Up state until either connectivity fails or the session is taken down administratively. If either the remote system signals Down state or the Detection Time expires, the session advances to Down state.", return_tensors="pt")

# move the input from CPU to GPU
if USE_GPU:
    inputs = inputs.cuda()

# generate the output token ids
outputs = model.generate(inputs)

# map the token ids back to readable text
print(tokenizer.decode(outputs[0]))