# baseline DeBERTa model
export TASK_NAME=logiqa
export MODEL_NAME=microsoft/deberta-xlarge
export LOGIQA_DIR=../../logiqa-data

deepspeed --num_gpus=2 train_logi.py \
    --model_type deberta \
    --model_name_or_path $MODEL_NAME \
    --task_name $TASK_NAME \
    --data_dir $LOGIQA_DIR \
    --do_lower_case \
    --do_train \
    --do_eval \
    --max_seq_length 256 \
    --learning_rate 7e-6 \
    --num_train_epochs 10.0 \
    --per_gpu_eval_batch_size 4  \
    --per_gpu_train_batch_size 1  \
    --gradient_accumulation_steps 8  \
    --overwrite_cache \
    --pad_to_max_length \
    --logging_steps 40 \
    --save_steps 200 \
    --fp16 \
    --output_dir ../../Checkpoints/$TASK_NAME/deberta-xlarge_ds_lr0.7_256_e10 \
    --run_name deberta_xlarge_ds_lr0.7_256_e10 \
    --do_test \



