"""Utility functions. """


import os

def get_dataset_path(args):
    """Rule-based dataset path generation.
    e.g. 'data/table-split/raw/concat/all0510'.
    """
    
    if hasattr(args, 'experiment_name') and (args.experiment_name == 'pg'):
        split_name = f'{args.split_method}-split-parsed'
    else:
        split_name = f'{args.split_method}-split'

    dataset_dir = os.path.join(
        args.dataset_subdir, 
        split_name, 
        args.link_method, 
        args.serial_method, 
        args.dataset_name
    )
    
    if hasattr(args, 'experiment_name') and (args.experiment_name == 'pg'):
        split_name = f'{args.split_method}-split-parsed'
    else:
        split_name = f'{args.split_method}-split'
        
    if hasattr(args, 'sample_name'):
        sample_dir = os.path.join(
            args.dataset_subdir, 
            split_name, 
            args.link_method, 
            args.serial_method, 
            args.sample_name
        )
        return dataset_dir, sample_dir
    return dataset_dir


def get_run_dir(args):
    """Rule-based dataset path generation.
    e.g. './runs/t5-raw-concat-all0510'.
    """
    
    run_dir = os.path.join(
        args.run_subdir, 
        f'{args.experiment_name}-{args.link_method}-{args.serial_method}-{args.dataset_name}', 
    )
    return run_dir

