#!/usr/bin/env bash
export DATASET_DIR=ReclorDataset
export TASK_NAME=LogiGraph
export MODEL_DIR=/path/to/roberta-large

export TOKENIZERS_PARALLELISM=false

export RUN_NAME=AdaLoGN_ReClor_raw

export DATASET_DIR=$DATASET_DIR
export MODEL_TYPE=Roberta

export truncate_edges_num=50
export truncate_nodes_num=25

CUDA_VISIBLE_DEVICES=0 python run_multiple_choice.py \
  --run_name $RUN_NAME \
  --task_name $TASK_NAME \
  --model_name_or_path $MODEL_DIR \
  --data_dir $DATASET_DIR \
  --do_train \
  --do_eval \
  --seed 123 \
  --model_type $MODEL_TYPE \
  --max_seq_length 384 \
  --per_device_eval_batch_size 16 \
  --per_device_train_batch_size 1 \
  --gradient_accumulation_steps 8 \
  --num_train_epochs 10 \
  --output_dir Checkpoints/$DATASET_DIR/$TASK_NAME/$GRAPH_TYPE/$GNN_TYPE/$RUN_NAME \
  --logging_steps 200 \
  --learning_rate 7e-6 \
  --overwrite_output_dir \
  --evaluation_strategy epoch \
  --save_strategy epoch \
  --metric_for_best_model acc_dev \
  --gnn_layers_num 2 \
  --save_total_limit 2 \
  --graph_extension false \
  --subgraph true \
  --extension false \
  --dropout_ratio 0.1 \
  --roberta_class 4 \
  --warmup_ratio 0.1 \
  --fc false \
  --label_smoothing true \
  --extension_threshold 0.7
