import pathlib
import re
from glob import glob
from pathlib import Path


def verify_files(file_list, exists=True):
    """

    :param file_list:
    :param exists:
    :return:
    """
    for filepath in file_list:
        if not pathlib.Path(filepath).is_file():
            if pathlib.Path(filepath).is_dir():
                raise FileNotFoundError('Expected filepath, not directory: %s. Aborting.' % filepath)
            if exists:
                raise FileNotFoundError('Input filepath %s does not exist. Aborting.' % filepath)
        elif not exists:
            raise FileExistsError('Input filepath %s already exists. Aborting' % filepath)


def verify_directories(dir_list, exists=True):
    for dirpath in dir_list:
        if not pathlib.Path(dirpath).is_dir():
            if pathlib.Path(dirpath).is_file():
                raise FileNotFoundError('Expected directory, not filepath: %s. Aborting.' % dirpath)
            if exists:
                raise NotADirectoryError('Directory %s does not exist. Aborting.' % dirpath)
        elif not exists:
            raise IsADirectoryError('Input directory %s already exists. Aborting.' % dirpath)


def get_numbered_path(filepath):
    path_stem = filepath.with_suffix('').as_posix()
    file_numbers = [0, ] if filepath.exists() else list()
    for file_name in glob(f'{path_stem}-*.json'):
        match = re.search(path_stem + r'-(\d+).json', file_name)
        if match:
            file_numbers.append(int(match.group(1)))
    return filepath if len(file_numbers) == 0 else Path(f'{path_stem}-{max(file_numbers)+1}.json')
