# errorbars.py

import numpy as np
import matplotlib.pyplot as plt
plt.style.use('seaborn-whitegrid')

F1s = {'ECtHR': {'Defendant State': [('C.E. European', 70.2), ('Rest', 48.7)],
                 'Gender': [('Male', 65.9), ('Female', 62.2)],
                 'Applicant Age': [('<=35', 60.0), ('<=65', 67.3), ('>65', 67.3)]}}


Support = {'ECtHR': {'Defendant State': [('C.E. European', 7224), ('Rest', 1776)],
            'Gender': [('Male', 4187), ('Female', 1507)],
            'Applicant Age': [('<=35', 868), ('<=65', 4279), ('>65', 1130)]}}


for key, attributes in F1s.items():
    X = []
    Y = []
    X_labels = []
    for attribute, groups in attributes.items():
        # Build the plot
        fig, ax = plt.subplots()
        if len(X):
            offset = [X[-1] + 1] * len(groups)
        else:
            offset = [0] * len(groups)
        x = list(range(len(groups))) + offset
        y = [group[1] for group in groups]
        x_labels = [group[0] for group in groups]
        X.extend(x)
        Y.extend(y)
        X_labels.extend(x_labels)
    ax.bar(X, Y, align='center', alpha=0.5, ecolor='black', capsize=10, color='blue', label='ERM', width=0.5)
    ax.set_xticks(X)
    ax.set_xticklabels(X_labels)
    plt.ylabel('Macro-F1')
    plt.xticks(rotation=10)
    ax.yaxis.grid(True)
    # Save the figure and show
    plt.tight_layout()
    # plt.savefig('bar_plot_with_error_bars.png')
    plt.show()