## Utility script to separate the sentences from a *.tsv file
import sys

LANGUAGE=sys.argv[1]
with open(f'./carb/data/gold/{LANGUAGE}_test.tsv', 'r') as f:
    data = f.readlines()


sentences = []
for ext_data in data:
    sentence = ext_data.strip().split('\t')[0]
    if sentence not in sentences:
        sentences.append(sentence)

with open(f'./carb/data/{LANGUAGE}_test.input','w') as f:
    f.write("\n".join(sentences)+'\n')

print('Total number of sentences in ', LANGUAGE, ' is ', len(sentences))