import sys
import os

import argparse
import json

def getParser():
    parser = argparse.ArgumentParser(description="parser for arguments", formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("-l", "--logfile", type=str, help="log file", required=True)
    parser.add_argument("-o", "--outfile", type=str, help="output file json", required=True)
    return parser

def parse2dict(logfile):
    outdict = {}
    line_number = 0
    delim1 = " "
    with open(logfile, 'r') as fin:
        for line in fin:
            line = line.strip()
            if line.startswith("Evaluation") or line.startswith("Test"):
                continue
            if line:
                if line_number%7 == 0:
                    model_name = line
                    cur_dict = outdict.setdefault(model_name, {})
                elif line_number%7 in [1, 3, 5]:
                    key = line
                    perf_dict = cur_dict.setdefault(key, {})
                else:
                    x = line.split(delim1)
                    perf_dict['MRR'] = float(x[0])
                    perf_dict['MR'] = float(x[1])
                    perf_dict['P@1'] = float(x[2])
                    perf_dict['P@10'] = float(x[3])
                line_number += 1
    return outdict

def main():
    parser = getParser()
    try:
        params = parser.parse_args()
    except:
        # parser.print_help()
        sys.exit(1)
    outdict = parse2dict(params.logfile)
    with open(params.outfile, 'w') as fout:
        json.dump(outdict, fout)
    for key, value in outdict.items():
        perfs = [key]
        for sp in ['head', 'tail', 'avg']:
            perfs.append("%f, %f, %f, %f" % (value[sp]['MRR'], value[sp]['MR'], value[sp]['P@1'], value[sp]['P@10']))
        print(",".join(perfs))

if __name__ == "__main__":
    main()

