# Data Schemas

- [Card](#card)
- [MultiLabel](#multilabel)

##  Card

#### Sample

```json
// annotations.data
{
    "text": "<b>松本伊代</b>が20年愛用するミルク液がすごい",
    "show_ambiguous_button": true,
    "hidden_data": {
        "desc": "集計時用のデータです。何を入れてもOKです。", 
        "type": "dictでもよいし、strでもよいです"
    }
}
// users_annotations.result_data
{
    "result": "Yes"
}
```

#### Detail

| table.param       | key                   | type                         | *required | default | comment                                            |
| ----------------- | --------------------- | ---------------------------- | --------- | ------- | -------------------------------------------------- |
| annotations.data  | text                  | string                       | *         |         | カード内テキスト                             |
|                   | baseline_text         | string                       |           |         | 基準（比較対象）となるテキスト                     |
|                   | show_ambiguous_button | boolean                      |           | true    | 曖昧ボタンを表示するか否か                         |
|                   | question_overwrite    | string                       |           |         | tasks.question（質問文）を上書きしたい時のテキスト |
|                   | hidden_data           | string \|Dict                |           |         | 集計用のデータ                                     |
| users_annotations | result_data           | "Yes" \| "No" \| "Ambiguous" | *         |         | ユーザの回答                                       |

## MultiLabel

#### Sample

```json
// annotations.data
{
    "text": "松本伊代が20年愛用するミルク液がすごい", 
    "choices": ["化粧水", "クリーム", "乳液", "リップ"],
    "hidden_data": {
        "desc": "集計時用のデータです。何を入れてもOKです。", 
        "type": "dictでもよいし、strでもよいです"
    }
}
// users_annotations.result_data
{
    "result": ["化粧水", "乳液"]
}
```

#### Detail

| table.param      | key            | type     | *required | default | comment                        |
| ---------------- | -------------- | -------- | --------- | ------- | ------------------------------ |
| annotations.data | text           | string   | *         |         | アノテーション対象のテキスト   |
|                  | choices        | string[] | *         |         | 選択肢                         |
|                  | max_select_num | int      |           | inf     | 選択できるタグの上限数         |
|                  | baseline_text  | string   |           |         | 基準（比較対象）となるテキスト |
|                  | hidden_data    | string \| Dict      |           |         | 集計用のデータ |
| users_annotation | result_data    | string[] | *         |         | ユーザの回答（複数回答OK）     |


